<?php
// DB connection - adjust with your own DB credentials
$host = 'localhost';
$db   = 'whsvhgjk_loanda';
$user = 'whsvhgjk_loanda';
$pass = 'whsvhgjk_loanda';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    exit('Database connection failed: ' . $e->getMessage());
}

// Check if token is provided in URL
if (!isset($_GET['token']) || empty($_GET['token'])) {
    exit('Invalid verification link.');
}

$token = $_GET['token'];

// Look up the user by the verification token
$stmt = $pdo->prepare("SELECT id, email, is_verified FROM users WHERE verification_token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch();

if (!$user) {
    exit('Invalid or expired verification token.');
}

if ($user['is_verified']) {
    exit('Your account is already verified.');
}

// Update user to set verified status and clear the token
$update = $pdo->prepare("UPDATE users SET is_verified = 1, verification_token = NULL WHERE id = ?");
$update->execute([$user['id']]);

echo "Thank you, your account has been successfully verified. You may now <a href='login.php'>log in</a>.";
?>
