<?php
error_reporting(E_ALL); // Report all PHP errors
ini_set('display_errors', 1); // Display errors on the page
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../classes/Transaction.php';
require_once __DIR__ . '/../classes/User.php';

checkAuthentication();

$user = new User();
$currentUser = $user->getUserById($_SESSION['user_id']);
$transaction = new Transaction();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'], $_POST['method'])) {
    $amount = (float)$_POST['amount'];
    $method = trim($_POST['method']);
    
    if ($amount <= 0) {
        $error = 'Invalid deposit amount';
    } else {
        // Handle file upload
        $proofUrl = '';
        if (isset($_FILES['proof']) && $_FILES['proof']['error'] === UPLOAD_ERR_OK) {
            $uploadDir = __DIR__ . '/../uploads/proofs/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }
            
            $extension = pathinfo($_FILES['proof']['name'], PATHINFO_EXTENSION);
            $filename = 'deposit_' . $_SESSION['user_id'] . '_' . time() . '.' . $extension;
            $destination = $uploadDir . $filename;
            
            if (move_uploaded_file($_FILES['proof']['tmp_name'], $destination)) {
                $proofUrl = '/uploads/proofs/' . $filename;
            } else {
                $error = 'Failed to upload proof';
            }
        }
        
        if (empty($error)) {
            // Create deposit transaction
            $transactionId = $transaction->create([
                'user_id' => $_SESSION['user_id'],
                'type' => 'deposit',
                'amount' => $amount,
                'method' => $method,
                'status' => 'pending',
                'proof_url' => $proofUrl
            ]);
            
            if ($transactionId) {
                $success = 'Deposit request submitted successfully. Please wait for admin approval.';
            } else {
                $error = 'Failed to create deposit request';
            }
        }
    }
}

include __DIR__ . '/../includes/header.php';
?>

<div class="container mx-auto px-4 py-8">
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold mb-6">Deposit Funds</h1>
        
        <?php if ($error): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <div class="bg-white rounded-xl shadow-md p-6">
            <form method="POST" enctype="multipart/form-data">
                <div class="mb-4">
                    <label for="amount" class="block text-gray-700 font-medium mb-2">Amount ($)</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="10" required
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-sm text-gray-500 mt-1">Minimum deposit: $10.00</p>
                </div>
                
                <div class="mb-4">
                    <label for="method" class="block text-gray-700 font-medium mb-2">Payment Method</label>
                    <select id="method" name="method" required
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Select Payment Method</option>
                        <option value="Bank Transfer">Bank Transfer</option>
                        <option value="Bitcoin">Bitcoin</option>
                        <option value="Ethereum">Ethereum</option>
                        <option value="USDT">USDT (TRC20/ERC20)</option>
                    </select>
                </div>
                
                <div class="mb-6">
                    <label for="proof" class="block text-gray-700 font-medium mb-2">Payment Proof (Screenshot/Receipt)</label>
                    <input type="file" id="proof" name="proof" accept="image/*,.pdf"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-sm text-gray-500 mt-1">Upload clear proof of payment (JPG, PNG or PDF)</p>
                </div>
                
                <button type="submit" 
                    class="w-full gradient-bg text-white py-2 px-4 rounded-lg font-medium hover:opacity-90 transition">
                    Submit Deposit Request
                </button>
            </form>
        </div>
        
        <!-- Deposit History -->
        <div class="mt-8 bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold mb-4">Deposit History</h2>
            
            <?php $deposits = $transaction->getUserTransactions($_SESSION['user_id'], 'deposit'); ?>
            <?php if (!empty($deposits)): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Method</th>
                                <th class="px-6 py-3