<?php
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'classes/User.php';

session_start();

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: user/dashboard.php');
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    $user = new User();
    $userData = $user->getUserByEmail($email);
    
    if ($userData && password_verify($password, $userData['password'])) {
        if ($userData['email_verified_at']) {
            $_SESSION['user_id'] = $userData['id'];
            $_SESSION['user_name'] = $userData['name'];
            $_SESSION['is_admin'] = $userData['is_admin'];
            
            header('Location: ' . ($userData['is_admin'] ? 'admin/dashboard.php' : 'user/dashboard.php'));
            exit();
        } else {
            $error = 'Please verify your email address first.';
        }
    } else {
        $error = 'Invalid email or password.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | InvestPro</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #1A237E 0%, #009688 100%);
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen flex items-center justify-center px-4">
        <div class="w-full max-w-md">
            <div class="gradient-bg text-white rounded-t-xl p-6 text-center shadow-lg">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                </svg>
                <h1 class="text-2xl font-bold mt-4">Welcome Back</h1>
                <p class="opacity-90 mt-2">Login to your account</p>
            </div>
            
            <div class="bg-white rounded-b-xl shadow-md p-6">
                <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $error; ?>
                </div>
                <?php endif; ?>
                
                <form method="POST">
                    <div class="mb-4">
                        <label for="email" class="block text-gray-700 font-medium mb-2">Email Address</label>
                        <input type="email" id="email" name="email" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div class="mb-6">
                        <label for="password" class="block text-gray-700 font-medium mb-2">Password</label>
                        <input type="password" id="password" name="password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <button type="submit" class="w-full gradient-bg text-white py-2 px-4 rounded-lg font-medium hover:opacity-90 transition">Login</button>
                    
                    <div class="mt-4 text-center">
                        <a href="forgot_password.php" class="text-blue-600 hover:underline">Forgot password?</a>
                    </div>
                </form>
                
                <div class="mt-6 pt-6 border-t border-gray-200 text-center">
                    <p class="text-gray-600">Don't have an account? <a href="register.php" class="text-blue-600 font-medium hover:underline">Register</a></p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>