<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include PHPMailer classes manually
require_once __DIR__ . '/PHPMailer/src/Exception.php';
require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/src/SMTP.php';

function sendEmail($to, $subject, $template, $data = []) {
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = getSMTPConfig('host');
        $mail->SMTPAuth   = true;
        $mail->Username   = getSMTPConfig('username');
        $mail->Password   = getSMTPConfig('password');
        $mail->SMTPSecure = getSMTPConfig('encryption');
        $mail->Port       = getSMTPConfig('port');

        // Recipients
        $mail->setFrom(getSMTPConfig('from_email'), getSMTPConfig('from_name'));
        $mail->addAddress($to);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = renderEmailTemplate($template, $data);
        $mail->AltBody = strip_tags(renderEmailTemplate($template, $data));

        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

function renderEmailTemplate($template, $data) {
    ob_start();
    include __DIR__ . "/../email_templates/{$template}.php";
    return ob_get_clean();
}

function getSMTPConfig($key) {
    $config = [
        'host' => 'mail.lizadexconcept.com.ng',  // your SMTP host
        'port' => 587,                           // or 465 if SSL
        'username' => 'support@lizadexconcept.com.ng', // your SMTP username
        'password' => 'Esther@2011',                    // your SMTP password
        'encryption' => 'tls',                   // or 'ssl'
        'from_email' => 'support@lizadexconcept.com.ng', // email sender address
        'from_name' => 'LizaDex Concept'         // sender name
    ];
    return $config[$key];
}

?>
