<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title ?? 'Investment Platform'; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #1A237E 0%, #009688 100%);
        }
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <header class="gradient-bg text-white shadow-lg">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center space-x-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                </svg>
                <span class="text-xl font-bold">InvestPro</span>
            </div>
            <nav class="hidden md:flex space-x-6">
                <a href="dashboard.php" class="font-medium hover:text-teal-200">Dashboard</a>
                <a href="invest.php" class="font-medium hover:text-teal-200">Invest</a>
                <a href="deposit.php" class="font-medium hover:text-teal-200">Deposit</a>
                <a href="withdraw.php" class="font-medium hover:text-teal-200">Withdraw</a>
                <?php if (isAdmin()): ?>
                    <a href="../admin/dashboard.php" class="font-medium hover:text-teal-200">Admin</a>
                <?php endif; ?>
            </nav>
            <div class="flex items-center space-x-4">
                <div class="relative">
                    <div class="h-8 w-8 rounded-full bg-teal-400 flex items-center justify-center text-white font-bold">
                        <?php echo strtoupper(substr($_SESSION['user_name'], 0, 1)); ?>
                    </div>
                </div>
                <a href="profile.php" class="font-medium hover:text-teal-200">Profile</a>
                <a href="../logout.php" class="font-medium hover:text-teal-200">Logout</a>
            </div>
        </div>
    </header>

    <main class="container mx-auto px-4 py-8">