<?php
// Enable error reporting for development
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'whsvhgjk_loanda');
define('DB_PASS', 'whsvhgjk_loanda');
define('DB_NAME', 'whsvhgjk_loanda');

// Create connection with error handling
function getDBConnection() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception("Database connection failed: " . $conn->connect_error);
        }
        
        // Set charset to utf8mb4 for proper encoding
        if (!$conn->set_charset("utf8mb4")) {
            throw new Exception("Error loading character set utf8mb4: " . $conn->error);
        }
        
        return $conn;
    } catch (Exception $e) {
        // Log the error to a file
        error_log($e->getMessage());
        
        // Display user-friendly error message
        die("We're experiencing technical difficulties. Please try again later. " . 
            (ini_get('display_errors') ? "<br>Error details: " . $e->getMessage() : ""));
    }
}

// Close connection with error handling
function closeDBConnection($conn) {
    try {
        if ($conn instanceof mysqli && $conn->ping()) {
            $conn->close();
        }
    } catch (Exception $e) {
        error_log("Error closing database connection: " . $e->getMessage());
    }
}

// Custom error handler function
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    if (!(error_reporting() & $errno)) {
        // This error code is not included in error_reporting
        return;
    }
    
    $errorTypes = [
        E_ERROR             => 'Error',
        E_WARNING           => 'Warning',
        E_PARSE             => 'Parse Error',
        E_NOTICE            => 'Notice',
        E_CORE_ERROR        => 'Core Error',
        E_CORE_WARNING      => 'Core Warning',
        E_COMPILE_ERROR     => 'Compile Error',
        E_COMPILE_WARNING   => 'Compile Warning',
        E_USER_ERROR        => 'User Error',
        E_USER_WARNING      => 'User Warning',
        E_USER_NOTICE       => 'User Notice',
        E_STRICT            => 'Strict Notice',
        E_RECOVERABLE_ERROR => 'Recoverable Error',
        E_DEPRECATED        => 'Deprecated',
        E_USER_DEPRECATED   => 'User Deprecated'
    ];
    
    $errorType = isset($errorTypes[$errno]) ? $errorTypes[$errno] : 'Unknown Error';
    
    $errorMessage = "[$errorType] $errstr in $errfile on line $errline";
    
    // Log the error
    error_log($errorMessage);
    
    // Display error if enabled
    if (ini_get('display_errors')) {
        echo "<div class='error-box' style='background:#ffebee;border-left:4px solid #f44336;padding:10px;margin:10px 0;'>
                <strong>$errorType:</strong> $errstr<br>
                <small>File: $errfile (Line: $errline)</small>
              </div>";
    }
    
    // Don't execute PHP internal error handler
    return true;
}

// Set custom error handler
set_error_handler("customErrorHandler");

// Exception handler
function customExceptionHandler($exception) {
    error_log("Uncaught Exception: " . $exception->getMessage() . " in " . $exception->getFile() . ":" . $exception->getLine());
    
    if (ini_get('display_errors')) {
        echo "<div class='exception-box' style='background:#fff3e0;border-left:4px solid #ff9800;padding:10px;margin:10px 0;'>
                <strong>Uncaught Exception:</strong> " . $exception->getMessage() . "<br>
                <small>File: " . $exception->getFile() . " (Line: " . $exception->getLine() . ")</small>
              </div>";
    } else {
        echo "<div class='error-message'>An unexpected error occurred. Please try again later.</div>";
    }
}

set_exception_handler("customExceptionHandler");

// Shutdown function to catch fatal errors
function shutdownHandler() {
    $error = error_get_last();
    if ($error !== NULL && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        customErrorHandler($error['type'], $error['message'], $error['file'], $error['line']);
    }
}

register_shutdown_function('shutdownHandler');
?>