<!-- email_verification.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Verify Your Email</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        h2 {
            color: #333;
        }

        p {
            font-size: 16px;
            color: #555;
        }

        .button {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 20px;
            background-color: #1A237E;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
        }

        .footer {
            margin-top: 40px;
            font-size: 12px;
            color: #999;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Hello <?php echo htmlspecialchars($name); ?>,</h2>

        <p>Thank you for registering on <strong>LizaDex Concept</strong>.</p>

        <p>To complete your registration, please click the button below to verify your email address:</p>

        <a href="<?php echo htmlspecialchars($link); ?>" class="button">Verify My Email</a>

        <p>If the button above doesn’t work, copy and paste this URL into your browser:</p>
        <p><a href="<?php echo htmlspecialchars($link); ?>"><?php echo htmlspecialchars($link); ?></a></p>

        <div class="footer">
            <p>If you did not create an account, please ignore this email.</p>
            <p>&copy; <?php echo date('Y'); ?> LizaDex Concept. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
