<?php
// classes/Transaction.php

class Transaction {
    private $db;
    
    public function __construct() {
        $this->db = getDBConnection();
    }
    
    public function getRecentTransactions($userId = null, $limit = 5) {
        $sql = "SELECT * FROM transactions";
        if ($userId) {
            $sql .= " WHERE user_id = ?";
        }
        $sql .= " ORDER BY created_at DESC LIMIT ?";
        
        $stmt = $this->db->prepare($sql);
        
        if ($userId) {
            $stmt->bind_param("ii", $userId, $limit);
        } else {
            $stmt->bind_param("i", $limit);
        }
        
        $stmt->execute();
        $result = $stmt->get_result();
        
        $transactions = [];
        while ($row = $result->fetch_assoc()) {
            $transactions[] = $row;
        }
        
        return $transactions;
    }
    
    public function create(array $data) {
        $stmt = $this->db->prepare("
            INSERT INTO transactions 
            (user_id, type, amount, method, status, proof_url, admin_id) 
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->bind_param(
            "isdsssi",
            $data['user_id'],
            $data['type'],
            $data['amount'],
            $data['method'] ?? null,
            $data['status'] ?? 'pending',
            $data['proof_url'] ?? null,
            $data['admin_id'] ?? null
        );
        
        $stmt->execute();
        return $this->db->insert_id;
    }
    
    public function approve($transactionId, $adminId) {
        $stmt = $this->db->prepare("
            UPDATE transactions 
            SET status = 'approved', processed_at = NOW(), admin_id = ? 
            WHERE id = ?
        ");
        $stmt->bind_param("ii", $adminId, $transactionId);
        return $stmt->execute();
    }
    
    // Add other transaction-related methods here
}