document.addEventListener('DOMContentLoaded', function() {
    // ROI Performance Chart
    const roiCtx = document.getElementById('roiChart').getContext('2d');
    const roiChart = new Chart(roiCtx, {
        type: 'line',
        data: {
            labels: chartData.roiPerformance.labels,
            datasets: [{
                label: 'ROI Earnings',
                data: chartData.roiPerformance.data,
                backgroundColor: 'rgba(0, 150, 136, 0.2)',
                borderColor: 'rgba(0, 150, 136, 1)',
                borderWidth: 2,
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return '$' + context.raw.toFixed(2);
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '$' + value;
                        }
                    }
                }
            }
        }
    });

    // Investment Distribution Chart
    const investmentCtx = document.getElementById('investmentChart').getContext('2d');
    const investmentChart = new Chart(investmentCtx, {
        type: 'doughnut',
        data: {
            labels: chartData.investmentDistribution.labels,
            datasets: [{
                data: chartData.investmentDistribution.data,
                backgroundColor: [
                    'rgba(26, 35, 126, 0.8)',
                    'rgba(0, 150, 136, 0.8)',
                    'rgba(156, 39, 176, 0.8)',
                    'rgba(255, 152, 0, 0.8)',
                    'rgba(33, 150, 243, 0.8)'
                ],
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'right',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.raw || 0;
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = Math.round((value / total) * 100);
                            return `${label}: $${value.toFixed(2)} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
});