<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';
require_once '../classes/User.php';
require_once '../classes/Investment.php';
require_once '../classes/Transaction.php';

checkAuthentication();
if (!isAdmin()) {
    header('Location: ../user/dashboard.php');
    exit();
}

$user = new User();
$investment = new Investment();
$transaction = new Transaction();

// Get stats
$totalUsers = $user->getTotalCount();
$activeInvestments = $investment->getTotalActiveCount();
$pendingDeposits = $transaction->getPendingCount('deposit');
$pendingWithdrawals = $transaction->getPendingCount('withdrawal');

// Get recent transactions
$recentTransactions = $transaction->getRecentTransactions(null, 5);

// Include header
include '../includes/header.php';
?>

<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold mb-8">Admin Dashboard</h1>
    
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Total Users -->
        <div class="bg-white rounded-xl shadow-md p-6 card-hover">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                </div>
                <div>
                    <p class="text-gray-500">Total Users</p>
                    <h3 class="text-2xl font-bold"><?php echo number_format($totalUsers); ?></h3>
                </div>
            </div>
        </div>
        
        <!-- Active Investments -->
        <div class="bg-white rounded-xl shadow-md p-6 card-hover">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-teal-100 text-teal-600 mr-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                    </svg>
                </div>
                <div>
                    <p class="text-gray-500">Active Investments</p>
                    <h3 class="text-2xl font-bold"><?php echo number_format($activeInvestments); ?></h3>
                </div>
            </div>
        </div>
        
        <!-- Pending Deposits -->
        <div class="bg-white rounded-xl shadow-md p-6 card-hover">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <p class="text-gray-500">Pending Deposits</p>
                    <h3 class="text-2xl font-bold"><?php echo number_format($pendingDeposits); ?></h3>
                </div>
            </div>
        </div>
        
        <!-- Pending Withdrawals -->
        <div class="bg-white rounded-xl shadow-md p-6 card-hover">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3" />
                    </svg>
                </div>
                <div>
                    <p class="text-gray-500">Pending Withdrawals</p>
                    <h3 class="text-2xl font-bold"><?php echo number_format($pendingWithdrawals); ?></h3>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Transactions -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-8">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-xl font-bold">Recent Transactions</h3>
            <a href="transactions.php" class="text-blue-600 hover:underline">View All</a>
        </div>
        
        <?php if (!empty($recentTransactions)): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php foreach ($recentTransactions as $txn): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php 
                                $userData = $user->getUserById($txn['user_id']);
                                echo htmlspecialchars($userData['name']); 
                                ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo ucfirst($txn['type']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">$<?php echo number_format($txn['amount'], 2); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo date('M d, Y', strtotime($txn['created_at'])); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    <?php echo $txn['status'] === 'approved' ? 'bg-green-100 text-green-800' : 
                                         ($txn['status'] === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                                    <?php echo ucfirst($txn['status']); ?>
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php if ($txn['status'] === 'pending'): ?>
                                    <a href="process_transaction.php?id=<?php echo $txn['id']; ?>&action=approve" class="text-green-600 hover:underline mr-2">Approve</a>
                                    <a href="process_transaction.php?id=<?php echo $txn['id']; ?>&action=reject" class="text-red-600 hover:underline">Reject</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-8">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z" />
                </svg>
                <h4 class="mt-2 text-lg font-medium text-gray-700">No recent transactions</h4>
                <p class="mt-1 text-gray-500">Transactions will appear here</p>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Quick Actions -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Manage Users -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold mb-4">Manage Users</h3>
            <p class="text-gray-600 mb-4">View and manage all registered users</p>
            <a href="users.php" class="inline-block gradient-bg text-white px-6 py-2 rounded-lg font-medium hover:opacity-90 transition">Go to Users</a>
        </div>
        
        <!-- Manage Investments -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold mb-4">Investment Plans</h3>
            <p class="text-gray-600 mb-4">Create and manage investment plans</p>
            <a href="investments.php" class="inline-block gradient-bg text-white px-6 py-2 rounded-lg font-medium hover:opacity-90 transition">Manage Plans</a>
        </div>
        
        <!-- System Settings -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold mb-4">System Settings</h3>
            <p class="text-gray-600 mb-4">Configure platform settings</p>
            <a href="settings.php" class="inline-block gradient-bg text-white px-6 py-2 rounded-lg font-medium hover:opacity-90 transition">Settings</a>
        </div>
    </div>
</div>

<?php
// Include footer
include '../includes/footer.php';
?>