<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';
require_once '../classes/Transaction.php';
require_once '../classes/User.php';
require_once '../includes/mailer.php';

checkAuthentication();
if (!isAdmin()) {
    header('Location: ../user/dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['transaction_id'], $_POST['action'])) {
    $transaction = new Transaction();
    $user = new User();
    
    $transactionData = $transaction->getById($_POST['transaction_id']);
    
    if ($_POST['action'] === 'approve') {
        // Approve deposit
        $db = getDBConnection();
        $db->autocommit(false);
        
        try {
            // 1. Update transaction status
            $transaction->approve($_POST['transaction_id'], $_SESSION['user_id']);
            
            // 2. Credit user's wallet
            $user->updateBalance($transactionData['user_id'], $transactionData['amount']);
            
            // 3. Record credit transaction
            $transaction->create([
                'user_id' => $transactionData['user_id'],
                'type' => 'credit',
                'amount' => $transactionData['amount'],
                'status' => 'approved',
                'admin_id' => $_SESSION['user_id']
            ]);
            
            $db->commit();
            
            // Send approval notification
            $userData = $user->getUserById($transactionData['user_id']);
            sendEmail(
                $userData['email'],
                'Deposit Approved',
                'deposit_approved',
                [
                    'name' => $userData['name'],
                    'amount' => $transactionData['amount'],
                    'balance' => $userData['balance'] + $transactionData['amount']
                ]
            );
            
            $_SESSION['success'] = 'Deposit approved successfully';
        } catch (Exception $e) {
            $db->rollback();
            $_SESSION['error'] = 'Failed to approve deposit: ' . $e->getMessage();
        }
    } else {
        // Reject deposit
        $transaction->reject($_POST['transaction_id'], $_SESSION['user_id']);
        
        // Send rejection notification
        $userData = $user->getUserById($transactionData['user_id']);
        sendEmail(
            $userData['email'],
            'Deposit Rejected',
            'deposit_rejected',
            [
                'name' => $userData['name'],
                'amount' => $transactionData['amount'],
                'reason' => $_POST['reason'] ?? 'Not specified'
            ]
        );
        
        $_SESSION['success'] = 'Deposit rejected successfully';
    }
    
    header('Location: transactions.php');
    exit();
}

// ... rest of the page for displaying the approval form
?>